﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using System.ServiceModel;
using InfoWorld.HL7.ITS;
using SC = BMS.DataContracts;
using FC = BMS.Facade.Data;
using BMS.Facade.Translators;
using BMSService = BMS.ServicesWrapper.BMService;
using BMS.ServicesWrapper.BMService;

namespace BMS.Workflows.CustomActivities
{
    public class UpdateWaitingListItem : CodeActivity
    {
        public InArgument<FC.WaitingListItem> WaitingListItem { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SC.WaitingListItem waitingListItem = this.WaitingListItem.Get<FC.WaitingListItem>(context).ToDataContract();
                if (waitingListItem.FlowId == null || waitingListItem.FlowId == Guid.Empty)
                    waitingListItem.FlowId = context.WorkflowInstanceId;
                BMSFactory.BedManagerOperationsClientFromWCF.UpdateWaitingListItem(waitingListItem);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
